unit Form;

{$I delphi.inc}

interface

uses
  Windows, Messages, SysUtils, {$IFDEF D6OR7}Variants, {$ENDIF}Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, jsintf;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Edit1: TEdit;
    procedure Button1Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    FEngine: TJSEngine;
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
begin
  FEngine := TJSEngine.Create(40000);
  FEngine.StartDebugger;

  FEngine.Global.AddNativeObject(Edit1, 'edit');
  FEngine.Global.AddNativeObject(Button1, 'button');

  FEngine.Global.Evaluate('function toggle() { ' +
                          '  edit.Visible = ! edit.Visible;' +   // Toggle the visible property on/off
                          '  button.Caption = (edit.Visible ? "Hide" : "Show");' + // Change button
                          '}');
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  FEngine.Free;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  FEngine.Global.Evaluate('toggle()');
end;

end.
